//Waveform synthesis of x(t)=r(t)-2r(t-1)+r(t-2)
//Windows 10
//Scilab 6.1.0
clear 
clc
f=input('Enter the sampling frequency:')
T=1/f;
U=input('Enter the upper bound for the time axis:')
t=0:T:U;
//Finding the first Constituent Ramp
x=t;
//Finding the second constituent Ramp
y=zeros(1,length(t));
z=y;
i=find(t==1);
j=length(i:length(t));
y(i:i+j-1)=2*x(1:j)
//Finding the third constituent  Ramp
i=find(t==2);
j=length(i:length(t));
z(i:i+j-1)=x(1:j);
subplot(2,2,1)
xset("thickness",2)
plot2d(t,x-y+z,rect=[0 0 U 1])
xtitle('x(t)=r(t)-2r(t-1)+r(t-2)  with f=10 and U=3','Time','Amplitude')
legend('x(t)')
xgrid
subplot(2,2,2)
xset("thickness",2)
plot2d(t,x,rect=[0 0 U 1])
xtitle('First constituent ramp signal','Time','Amplitude')
legend('r(t)')
xgrid
subplot(2,2,3)
xset("thickness",2)
plot2d(t,-y,rect=[0 min(-y) U max(y)])
xtitle('Second constituent ramp signal','Time','Amplitude')
legend('-2r(t-1)')
xgrid
subplot(2,2,4)
xset("thickness",2)
plot2d(t,z,rect=[0 0 U 1])
xtitle('Third constituent ramp signal','Time','Amplitude')
legend('r(t-2)',3)
xgrid
//output Test case
//sampling frequency  10
// upper bound for the time axis   3
